####################
# ## PARAMETERS ## #
####################

config={
  # paths for connecting to cloud storage
  "vm_path": 'ebm-life-cycle/',
  "gs_path": 'gen-tfrc-uscentral1',

  # device type ('tpu' or 'gpu' or 'cpu')
  "device_type": 'tpu',

  'exp_dir': 'tfrc_out/attack',
  'exp_name': 'cifar10_test',
  'data_type': 'cifar10',
  'split': 'test',
  'image_dims': [32, 32, 3],

  'image_dims_clf': [32, 32, 3],
  'pixel_scale_clf': [-1, 1],

  'start_batch': 1,
  'end_batch': 100,
  'batch_size': 16,
  'shuffle': True,

  'adv_steps': 50,
  'adv_eps': 8.0,
  'adv_eta': 2.0,
  'adv_rand_start': True,

  'eot_attack_reps': 24,
  'eot_defense_reps': 128,

  'langevin_steps': 1500,
  'epsilon': 1.25e-2,
  'mcmc_temp': 1e-4,

  'ebm_weights': "gs://gen-tfrc-uscentral1/tfrc_out/cifar10/med_conv_sngan_21-08-23-06-20-54/checkpoints/ebm_200000.ckpt",
  'net_type': 'ebm_sngan',

  'clf_weights': "gs://gen-tfrc-europewest4/cifar10-wrn-clf/weights",

  'log_freq': 1,
  'record_image_states': False
}
